/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIASET_H
#define _IIASET_H

#include <iiacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IASetImpl : public IACollectionImpl {
public:

          ~IASetImpl
                            ();

  virtual
  void     Antivalence      (IASetImpl const&);

  virtual
  void     AddAntivalence   (IASetImpl const&,
                             IASetImpl const&); 

  virtual
  void     AddDifference    (IASetImpl const&,
                             IASetImpl const&); 

  virtual
  void     AddIntersection  (IASetImpl const&,
                             IASetImpl const&);

  virtual
  void     AddUnion         (IASetImpl const&,
                             IASetImpl const&);

  virtual
  void     Difference       (IASetImpl const&);

  virtual
  void     Intersection     (IASetImpl const&);

  virtual
  void     Union            (IASetImpl const&);

  virtual
  IBoolean operator==       (IASetImpl const&) const = 0;

  IBoolean operator!=       (IASetImpl const&) const;

protected:

           IASetImpl
                            (Ops&);

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  INumber  RemoveAllOccurrences
                            (void const*);

private:


};

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
