/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIASM_H
#define _IIASM_H

#include <iiacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class IASortedMapImpl : public IACollectionImpl {
public:

          ~IASortedMapImpl
                            ();

  virtual
  void     Antivalence      (IASortedMapImpl const&);

  virtual
  void     AddAntivalence   (IASortedMapImpl const&,
                             IASortedMapImpl const&); 

  virtual
  void     AddDifference    (IASortedMapImpl const&,
                             IASortedMapImpl const&); 

  virtual
  void     AddIntersection  (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  virtual
  void     AddUnion         (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  virtual
  long     Compare          (IASortedMapImpl const&,
                             ICompFunc, void*) const;

  virtual
  void     Difference       (IASortedMapImpl const&);

  virtual
  void     Intersection     (IASortedMapImpl const&);

  virtual
  void     Union            (IASortedMapImpl const&);

  virtual
  IBoolean operator==       (IASortedMapImpl const&) const = 0;

  IBoolean operator!=       (IASortedMapImpl const&) const;

protected:

           IASortedMapImpl
                            (Ops&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  INumber  RemoveAllOccurrences
                            (void const*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const;

private:


};

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
