/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIBAGLST_H
#define _IIBAGLST_H

#include <iibagkb.h>


#include <iikblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IBagOnKeyBagImpl
         <IKeyBagAsListImpl> IBagAsListImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsListImpl> IABagAsListOps;

template <class Element, class ElementOps, class Implementation>
class IBagAsListOps :
  public IABagAsListOps {

  typedef  IABagAsListOps Inherited;

  typedef  IBagAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsListOps
                           (INumber);

           IBagAsListOps
                           (INumber, void*);

           IBagAsListOps
                           (IBagAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iibaglst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
