/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIBAGTAB_H
#define _IIBAGTAB_H

#include <iibagkb.h>


#include <iikbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IBagOnKeyBagImpl
         <IKeyBagAsTableImpl> IBagAsTableImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsTableImpl> IABagAsTableOps;

template <class Element, class ElementOps, class Implementation>
class IBagAsTableOps :
  public IABagAsTableOps {

  typedef  IABagAsTableOps Inherited;

  typedef  IBagAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsTableOps
                           (INumber);

           IBagAsTableOps
                           (INumber, void*);

           IBagAsTableOps
                           (IBagAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iibagtab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
