/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// ICBagImpl
// ---

// public members

template <class CInherited>
ICBagImpl <CInherited>::
ICBagImpl (Ops& ops, INumber numberOfElements)
: CInherited (ops, numberOfElements)
{
}

template <class CInherited>
ICBagImpl <CInherited>::
ICBagImpl
  (Ops& ops, ICBagImpl <CInherited> const& collection)
: CInherited (ops, collection)
{
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
Add (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor      (ClassName (), "Add")

  IBoolean hasBeenAdded = CInherited::Add (element, cursor);
  return hasBeenAdded;
}

template <class CInherited>
void
ICBagImpl <CInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ ICHECK_Identical (ClassName (), "AddAllFrom")

  CInherited::AddAllFrom (collection);
}

template <class CInherited>
void*
ICBagImpl <CInherited>::
Any () const
{ ICHECK_IsEmpty (ClassName (), "Any")

  return CInherited::Any ();
}

template <class CInherited>
void*
ICBagImpl <CInherited>::
ElementAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (ClassName (), "ElementAt")
  ICHECK_IsValid      (ClassName (), "ElementAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "ElementAt")
#endif

  return CInherited::ElementAt (cursor);
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
Locate (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "Locate")

  return CInherited::Locate (element, cursor);
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
LocateNext (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "LocateNext")
  ICHECK_IsValid (ClassName (), "LocateNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "LocateNext")
#endif

  return CInherited::LocateNext (element, cursor);
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
LocateOrAdd (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (ClassName (), "LocateOrAdd")

  return CInherited::LocateOrAdd (element, cursor);
}

template <class CInherited>
void
ICBagImpl <CInherited>::
RemoveAt (ICursorImpl& cursor)
{ ICHECK_IsFor        (ClassName (), "RemoveAt")
  ICHECK_IsValid      (ClassName (), "RemoveAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "RemoveAt")
#endif

  CInherited::RemoveAt (cursor);
}

template <class CInherited>
void
ICBagImpl <CInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ ICHECK_IsFor        (ClassName (), "ReplaceAt")
  ICHECK_IsValid      (ClassName (), "ReplaceAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "ReplaceAt")
#endif
  ICHECK_Replacement  (ClassName (), "ReplaceAt")

  CInherited::ReplaceAt (cursor, element);
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
SetToFirst (ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "SetToFirst")

  return CInherited::SetToFirst (cursor);
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
SetToNext (ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToNext")
  ICHECK_IsValid (ClassName (), "SetToNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToNext")
#endif

  return CInherited::SetToNext (cursor);
}

template <class CInherited>
IBoolean
ICBagImpl <CInherited>::
SetToNextDifferentElement (ICursorImpl& cursor) const
{ ICHECK_IsFor        (ClassName (), "SetToNextDifferentElement")
  ICHECK_IsValid      (ClassName (), "SetToNextDifferentElenent")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "SetToNextDifferentElement")
#endif

  return CInherited::SetToNextDifferentElement (cursor);
}

#pragma info (restore)
#pragma pack ()
