/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IICBAG_H
#define _IICBAG_H

#include <iiabag.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class CInherited>
class ICBagImpl : public CInherited {
public:

  typedef  CInherited::Ops Ops;

           ICBagImpl
                            (Ops&, INumber);

           ICBagImpl
                            (Ops&, ICBagImpl
                                    <CInherited> const&);

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void*    Any              () const;

  void*    ElementAt        (ICursorImpl const&) const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const& cursor,
                             void const*);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextDifferentElement
                            (ICursorImpl&) const;

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iicbag.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
