/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// ICEqualitySequenceImpl
// ---

// public members

template <class CInherited>
ICEqualitySequenceImpl <CInherited>::
ICEqualitySequenceImpl (Ops& ops, INumber numberOfElements)
: CInherited (ops, numberOfElements)
{
}

template <class CInherited>
ICEqualitySequenceImpl <CInherited>::
ICEqualitySequenceImpl
  (Ops& ops, ICEqualitySequenceImpl <CInherited> const& collection)
: CInherited (ops, collection)
{
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
Add (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor      (ClassName (), "Add")

  IBoolean hasBeenAdded = CInherited::Add (element, cursor);
  return hasBeenAdded;
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ ICHECK_Identical (ClassName (), "AddAllFrom")

  CInherited::AddAllFrom (collection);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
AddAsFirst (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (ClassName (), "AddAsFirst")

  CInherited::AddAsFirst (element, cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
AddAsLast (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (ClassName (), "AddAsLast")

  CInherited::AddAsLast (element, cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
AddAsNext (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor   (ClassName (), "AddAsNext")
  ICHECK_IsValid (ClassName (), "AddAsNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "AddAsNext")
#endif

  CInherited::AddAsNext (element, cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
AddAsPrevious (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor   (ClassName (), "AddAsPrevious")
  ICHECK_IsValid (ClassName (), "AddAsPrevious")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "AddAsPrevious")
#endif

  CInherited::AddAsPrevious (element, cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
AddAtPosition (IPosition position,
               void const* element,
               ICursorImpl& cursor)
{ ICHECK_IsFor     (ClassName (), "AddAtPosition")
  ICHECK_Position2 (ClassName (), "AddAtPosition")

  CInherited::AddAtPosition (position, element, cursor);
}

template <class CInherited>
void*
ICEqualitySequenceImpl <CInherited>::
Any () const
{ ICHECK_IsEmpty (ClassName (), "Any")

  return CInherited::Any ();
}

template <class CInherited>
void*
ICEqualitySequenceImpl <CInherited>::
ElementAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (ClassName (), "ElementAt")
  ICHECK_IsValid      (ClassName (), "ElementAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "ElementAt")
#endif

  return CInherited::ElementAt (cursor);
}

template <class CInherited>
void*
ICEqualitySequenceImpl <CInherited>::
ElementAtPosition (IPosition position) const
{ ICHECK_Position (ClassName (), "ElementAtPosition")

  return CInherited::ElementAtPosition (position);
}

template <class CInherited>
void*
ICEqualitySequenceImpl <CInherited>::
First () const
{ ICHECK_IsEmpty (ClassName (), "First")

  return CInherited::First ();
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
IsFirstAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (ClassName (), "IsFirstAt")
  ICHECK_IsValid      (ClassName (), "IsFirstAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "IsFirstAt")
#endif

  return CInherited::IsFirstAt (cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
IsLastAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (ClassName (), "IsLastAt")
  ICHECK_IsValid      (ClassName (), "IsLastAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "IsLastAt")
#endif

  return CInherited::IsLastAt (cursor);
}

template <class CInherited>
void*
ICEqualitySequenceImpl <CInherited>::
Last () const
{ ICHECK_IsEmpty (ClassName (), "Last")

  return CInherited::Last ();
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
Locate (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "Locate")

  return CInherited::Locate (element, cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
LocateFirst (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "LocateFirst")

  return CInherited::LocateFirst (element, cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
LocateLast (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "LocateLast")

  return CInherited::LocateLast (element, cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
LocateNext (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "LocateNext")
  ICHECK_IsValid (ClassName (), "LocateNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "LocateNext")
#endif

  return CInherited::LocateNext (element, cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
LocateOrAdd (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (ClassName (), "LocateOrAdd")

  return CInherited::LocateOrAdd (element, cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
LocatePrevious (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "LocatePrevious")
  ICHECK_IsValid (ClassName (), "LocatePrevious")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "LocatePrevious")
#endif

  return CInherited::LocatePrevious (element, cursor);
}

template <class CInherited>
IPosition
ICEqualitySequenceImpl <CInherited>::
PositionAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (ClassName (), "PositionAt")
  ICHECK_IsValid      (ClassName (), "PositionAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "PositionAt")
#endif

  return CInherited::PositionAt (cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
RemoveAt (ICursorImpl& cursor)
{ ICHECK_IsFor        (ClassName (), "RemoveAt")
  ICHECK_IsValid      (ClassName (), "RemoveAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "RemoveAt")
#endif

  CInherited::RemoveAt (cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
RemoveAtPosition (IPosition position)
{ ICHECK_Position (ClassName (), "RemoveAtPosition")

  CInherited::RemoveAtPosition (position);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
RemoveFirst ()
{ ICHECK_IsEmpty (ClassName (), "RemoveFirst")

  CInherited::RemoveFirst ();
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
RemoveLast ()
{ ICHECK_IsEmpty (ClassName (), "RemoveLast")

  CInherited::RemoveLast ();
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ ICHECK_IsFor        (ClassName (), "ReplaceAt")
  ICHECK_IsValid      (ClassName (), "ReplaceAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor       (ClassName (), "ReplaceAt")
#endif

  CInherited::ReplaceAt (cursor, element);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
ReplaceAtPosition (IPosition position, void const* element)
{ ICHECK_Position    (ClassName (), "ReplaceAtPosition")

  CInherited::ReplaceAtPosition (position, element);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
SetToFirst (ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "SetToFirst")

  return CInherited::SetToFirst (cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
SetToLast (ICursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "SetToLast")

  return CInherited::SetToLast (cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
SetToNext (ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToNext")
  ICHECK_IsValid (ClassName (), "SetToNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToNext")
#endif

  return CInherited::SetToNext (cursor);
}

template <class CInherited>
void
ICEqualitySequenceImpl <CInherited>::
SetToPosition (IPosition position, ICursorImpl& cursor) const
{ ICHECK_IsFor     (ClassName (), "SetToPosition")
  ICHECK_Position  (ClassName (), "SetToPosition")

  CInherited::SetToPosition (position, cursor);
}

template <class CInherited>
IBoolean
ICEqualitySequenceImpl <CInherited>::
SetToPrevious (ICursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToPrevious")
  ICHECK_IsValid (ClassName (), "SetToPrevious")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToPrevious")
#endif

  return CInherited::SetToPrevious (cursor);
}

#pragma info (restore)
#pragma pack ()
