/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ------------------
// ICMultiwayTreeImpl
// ------------------

// public members

template <class CInherited>
ICMultiwayTreeImpl <CInherited>::
ICMultiwayTreeImpl (Ops& ops)
: CInherited (ops)
{
}

template <class CInherited>
ICMultiwayTreeImpl <CInherited>::
ICMultiwayTreeImpl
  (Ops& ops, ICMultiwayTreeImpl <CInherited> const& tree)
: CInherited (ops, tree)
{
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
AddAsChild (ITreeCursorImpl const& cursor,
            IPosition position, void const* element)
{ ICHECK_IsFor     (ClassName (), "AddAsChild")
  ICHECK_IsValid   (ClassName (), "AddAsChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor    (ClassName (), "AddAsChild")
#endif
  ICHECK_Position3 (ClassName (), "AddAsChild")
  ICHECK_Child     (ClassName (), "AddAsChild")

  CInherited::AddAsChild (cursor, position, element);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
AddAsRoot (void const* element)
{ ICHECK_Root (ClassName (), "AddAsRoot")

  CInherited::AddAsRoot (element);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
AllSubtreeElementsDo (ITreeCursorImpl const& cursor, IApplFunc applFunc,
                      ITreeIterationOrder order, void* addArg)
{ ICHECK_IsFor   (ClassName (), "AllSubtreeElementsDo")
  ICHECK_IsValid (ClassName (), "AllSubtreeElementsDo")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "AllSubtreeElementsDo")
#endif

  return CInherited::AllSubtreeElementsDo
    (cursor, applFunc, order, addArg);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
AttachAsChild (ITreeCursorImpl const& cursor, IPosition position,
               IMultiwayTreeImpl& tree)
{ ICHECK_IsFor     (ClassName (), "AttachAsChild")
  ICHECK_IsValid   (ClassName (), "AttachAsChild")
  ICHECK_Position3 (ClassName (), "AttachAsChild")
  ICHECK_Cycle     (ClassName (), "AttachAsChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor    (ClassName (), "AttachAsChild")
#endif
  ICHECK_Child     (ClassName (), "AttachAsChild")

  CInherited::AttachAsChild (cursor, position, tree);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
AttachAsRoot (IMultiwayTreeImpl& tree)
{ ICHECK_Root (ClassName (), "AttachAsRoot")

  CInherited::AttachAsRoot (tree);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
AttachSubtreeAsChild (ITreeCursorImpl const& cursor,
                      IPosition position,
                      IMultiwayTreeImpl& tree,
                      ITreeCursorImpl const& thatCursor)
{ ICHECK_IsFor       (ClassName (), "AttachSubtreeAsChild")
  ICHECK_IsForThat   (ClassName (), "AttachSubtreeAsChild")
  ICHECK_IsValid     (ClassName (), "AttachSubtreeAsChild")
  ICHECK_IsThatValid (ClassName (), "AttachSubtreeAsChild")
  ICHECK_Position3   (ClassName (), "AttachSubtreeAsChild")
  ICHECK_Cycle2      (ClassName (), "AttachSubtreeAsChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor      (ClassName (), "AttachSubtreeAsChild")
  ICHECK_ThatCursor  (ClassName (), "AttachSubtreeAsChild")
#endif
  ICHECK_Child       (ClassName (), "AttachSubtreeAsChild")

  CInherited::AttachSubtreeAsChild (cursor, position, tree, thatCursor);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
AttachSubtreeAsRoot (IMultiwayTreeImpl& tree,
                     ITreeCursorImpl const& thatCursor)
{ ICHECK_IsForThat   (ClassName (), "AttachSubtreeAsRoot")
  ICHECK_IsThatValid (ClassName (), "AttachSubtreeAsRoot")
  ICHECK_Root        (ClassName (), "AttachSubtreeAsRoot")
#if defined (IALL_CHECKS)
  ICHECK_ThatCursor  (ClassName (), "AttachSubtreeAsRoot")
#endif

  CInherited::AttachSubtreeAsRoot (tree, thatCursor);
}

template <class CInherited>
IPosition
ICMultiwayTreeImpl <CInherited>::
ChildPositionAt (ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor   (ClassName (), "ChildPositionAt")
  ICHECK_IsValid (ClassName (), "ChildPositionAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "ChildPositionAt")
#endif

  return CInherited::ChildPositionAt (cursor);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
CopySubtree (IMultiwayTreeImpl const& tree,
             ITreeCursorImpl const& thatCursor)
{ ICHECK_IsForThat   (ClassName (), "CopySubtree")
  ICHECK_IsThatValid (ClassName (), "CopySubtree")
#if defined (IALL_CHECKS)
  ICHECK_ThatCursor  (ClassName (), "CopySubtree")
#endif

  CInherited::CopySubtree (tree, thatCursor);
}

template <class CInherited>
void*
ICMultiwayTreeImpl <CInherited>::
ElementAt (ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor   (ClassName (), "ElementAt")
  ICHECK_IsValid (ClassName (), "ElementAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "ElementAt")
#endif

  return CInherited::ElementAt (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
HasChild (IPosition position, ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor     (ClassName (), "HasChild")
  ICHECK_IsValid   (ClassName (), "HasChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor    (ClassName (), "HasChild")
#endif
  ICHECK_Position3 (ClassName (), "HasChild")

  return CInherited::HasChild (position, cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
IsLeaf (ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor   (ClassName (), "IsLeaf")
  ICHECK_IsValid (ClassName (), "IsLeaf")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "IsLeaf")
#endif

  return CInherited::IsLeaf (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
IsRoot (ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor   (ClassName (), "IsRoot")
  ICHECK_IsValid (ClassName (), "IsRoot")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "IsRoot")
#endif

  return CInherited::IsRoot (cursor);
}

template <class CInherited>
INumber
ICMultiwayTreeImpl <CInherited>::
NumberOfSubtreeElements (ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor   (ClassName (), "NumberOfSubtreeElements")
  ICHECK_IsValid (ClassName (), "NumberOfSubtreeElements")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "NumberOfSubtreeElements")
#endif

  return CInherited::NumberOfSubtreeElements (cursor);
}

template <class CInherited>
INumber
ICMultiwayTreeImpl <CInherited>::
NumberOfSubtreeLeaves (ITreeCursorImpl const& cursor) const
{ ICHECK_IsFor   (ClassName (), "NumberOfSubtreeLeaves")
  ICHECK_IsValid (ClassName (), "NumberOfSubtreeLeaves")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "NumberOfSubtreeLeaves")
#endif

  return CInherited::NumberOfSubtreeLeaves (cursor);
}

template <class CInherited>
INumber
ICMultiwayTreeImpl <CInherited>::
RemoveSubtree (ITreeCursorImpl& cursor)
{ ICHECK_IsFor   (ClassName (), "RemoveSubtree")
  ICHECK_IsValid (ClassName (), "RemoveSubtree")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "RemoveSubtree")
#endif

  return CInherited::RemoveSubtree (cursor);
}

template <class CInherited>
void
ICMultiwayTreeImpl <CInherited>::
ReplaceAt (ITreeCursorImpl const& cursor, void const* element)
{ ICHECK_IsFor   (ClassName (), "ReplaceAt")
  ICHECK_IsValid (ClassName (), "ReplaceAt")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "ReplaceAt")
#endif

  CInherited::ReplaceAt (cursor, element);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToChild (IPosition position, ITreeCursorImpl& cursor) const
{ ICHECK_IsFor     (ClassName (), "SetToChild")
  ICHECK_IsValid   (ClassName (), "SetToChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor    (ClassName (), "SetToChild")
#endif
  ICHECK_Position3 (ClassName (), "SetToChild")

  return CInherited::SetToChild (position, cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToFirst (ITreeCursorImpl& cursor, ITreeIterationOrder order) const
{ ICHECK_IsFor (ClassName (), "SetToFirst")

  return CInherited::SetToFirst (cursor, order);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToFirstExistingChild (ITreeCursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToFirstExistingChild")
  ICHECK_IsValid (ClassName (), "SetToFirstExistingChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToFirstExistingChild")
#endif

  return CInherited::SetToFirstExistingChild (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToLast (ITreeCursorImpl& cursor, ITreeIterationOrder order) const
{ ICHECK_IsFor (ClassName (), "SetToLast")

  return CInherited::SetToLast (cursor, order);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToLastExistingChild (ITreeCursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToLastExistingChild")
  ICHECK_IsValid (ClassName (), "SetToLastExistingChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToLastExistingChild")
#endif

  return CInherited::SetToLastExistingChild (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToNext (ITreeCursorImpl& cursor, ITreeIterationOrder order) const
{ ICHECK_IsFor (ClassName (), "SetToNext")

  return CInherited::SetToNext (cursor, order);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToNextExistingChild (ITreeCursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToNextExistingChild")
  ICHECK_IsValid (ClassName (), "SetToNextExistingChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToNextExistingChild")
#endif

  return CInherited::SetToNextExistingChild (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToParent (ITreeCursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToParent")
  ICHECK_IsValid (ClassName (), "SetToParent")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToParent")
#endif

  return CInherited::SetToParent (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToPrevious (ITreeCursorImpl& cursor, ITreeIterationOrder order) const
{ ICHECK_IsFor (ClassName (), "SetToPrevious")

  return CInherited::SetToPrevious (cursor, order);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToPreviousExistingChild (ITreeCursorImpl& cursor) const
{ ICHECK_IsFor   (ClassName (), "SetToPreviousExistingChild")
  ICHECK_IsValid (ClassName (), "SetToPreviousExistingChild")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (ClassName (), "SetToPreviousExistingChild")
#endif

  return CInherited::SetToPreviousExistingChild (cursor);
}

template <class CInherited>
IBoolean
ICMultiwayTreeImpl <CInherited>::
SetToRoot (ITreeCursorImpl& cursor) const
{ ICHECK_IsFor (ClassName (), "SetToRoot")

  return CInherited::SetToRoot (cursor);
}

#pragma info (restore)
#pragma pack ()
