/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IICMWT_H
#define _IICMWT_H

#include <iimwt.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class CInherited>
class ICMultiwayTreeImpl : public CInherited {
public:

  typedef  CInherited::Ops Ops;

           ICMultiwayTreeImpl
                            (Ops&);

           ICMultiwayTreeImpl
                            (Ops&,
                             ICMultiwayTreeImpl <CInherited> const&);

  void     AddAsChild       (ITreeCursorImpl const&,
                             IPosition, void const*);

  void     AddAsRoot        (void const*);

  IBoolean AllSubtreeElementsDo
                            (ITreeCursorImpl const&, IApplFunc,
                             ITreeIterationOrder, void*);

  void     AttachAsChild    (ITreeCursorImpl const&,
                             IPosition, IMultiwayTreeImpl&);

  void     AttachAsRoot     (IMultiwayTreeImpl&);

  void     AttachSubtreeAsChild
                            (ITreeCursorImpl const&, IPosition,
                             IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  void     AttachSubtreeAsRoot
                            (IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  IPosition
           ChildPositionAt  (ITreeCursorImpl const&) const;
  
  void     CopySubtree      (IMultiwayTreeImpl const&,
                             ITreeCursorImpl const&);

  void*    ElementAt        (ITreeCursorImpl const&) const;

  IBoolean HasChild         (IPosition, ITreeCursorImpl const&) const;

  IBoolean IsLeaf           (ITreeCursorImpl const&) const;

  IBoolean IsRoot           (ITreeCursorImpl const&) const;

  INumber  NumberOfSubtreeElements
                            (ITreeCursorImpl const&) const;


  INumber  NumberOfSubtreeLeaves
                            (ITreeCursorImpl const&) const;

  INumber  RemoveSubtree    (ITreeCursorImpl&);

  void     ReplaceAt        (ITreeCursorImpl const& cursor,
                             void const*);

  IBoolean SetToChild       (IPosition, ITreeCursorImpl&) const;

  IBoolean SetToFirst       (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToFirstExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToLast        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToLastExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToNext        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToNextExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToParent      (ITreeCursorImpl&) const;

  IBoolean SetToPrevious    (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  IBoolean SetToPreviousExistingChild
                            (ITreeCursorImpl&) const;

  IBoolean SetToRoot        (ITreeCursorImpl&) const;

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iicmwt.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
