#ifndef _IICONCTL_
  #define _IICONCTL_
/*******************************************************************************
* FILE NAME: iiconctl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IIconControl                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibmpctl.hpp>
#include <irect.hpp>

class IPointerHandle;
class IResourceId;
class ISize;
class IWindowHandle;
class IIconControlData;

#pragma pack(4)

class IIconControl : public IBitmapControl  {
typedef IBitmapControl
  Inherited;
public:
class Style;
/*------------------------ Constructors --------------------------------------*/
  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               const IResourceId& iconId,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               unsigned long iconId,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               const IPointerHandle& iconId = IPointerHandle(),
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parent,
               IWindow* owner,
               ISystemPointerHandle::Identifier icon,
               const IRectangle& initial= IRectangle(),
               const Style& style = defaultStyle() );

  IIconControl(unsigned long id,
               IWindow* parentDialog);

  IIconControl(const IWindowHandle& handle);

virtual
  ~IIconControl();

/*---------------------------------- Styles  ---------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IIconControl, IWindow, IControl, IStaticText);
                               // style class definition

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU sizeToIcon;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------- Icons --------------------------------------*/
virtual IIconControl
  &setIcon(unsigned long iconId),
  &setIcon(const IResourceId&  iconId),
  &setIcon(const IPointerHandle& handle);

virtual IIconControl
  &setIcon(ISystemPointerHandle::Identifier icon);

IPointerHandle
  icon() const;


/*---------------------------- Canvas Support --------------------------------*/
virtual IRectangle
  visibleRectangle   ( ) const;

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*--------------------------------- Private ----------------------------------*/

static Style
  currentDefaultStyle;

IIconControlData
 *fIconControlData;

IIconControl
  &initialize(const Style& style);

IPointerHandle
  iconHandle;
Boolean
  bSizeTo,
  returnback,
  bHalf;
friend class IIconHandler;

/*----------------------------- Hidden Functions -----------------------------*/
  IIconControl(const IIconControl&);
  IIconControl& operator=(const IIconControl&);
};  // class IIconControl

INESTEDBITFLAGCLASSFUNCS(Style, IIconControl);
                                  // global style functions

#pragma pack()

#endif  /* _IICONCTL_ */
