/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIESLST_H
#define _IIESLST_H

#include <iiesseq.h>


#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsListImpl> IEqualitySequenceAsListImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsListImpl> IAEqualitySequenceAsListOps;

template <class Element, class ElementOps, class Implementation>
class IEqualitySequenceAsListOps :
  public IAEqualitySequenceAsListOps {

  typedef  IEqualitySequenceAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsListOps
                           (INumber);

           IEqualitySequenceAsListOps
                           (INumber, void*);

           IEqualitySequenceAsListOps
                           (IEqualitySequenceAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  IBoolean EqualElements   (void const*, void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iieslst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
