/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIEXC_H
#define _IIEXC_H

#include <iiglobal.h>
#include <iexc.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)


#pragma SOMAsDefault (off)

  #define ICCEXCLASSSUPERCLASS(ibm,tal)\
    public ibm {\
    public:\
    typedef ibm InheritedIBM;

class IFullExceptionImpl :
  ICCEXCLASSSUPERCLASS (IFullException,\
                        TFullException)
public:

           IFullExceptionImpl
                            (char const*);

           IFullExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IFullExceptionImpl
                            (IFullExceptionImpl const&);

          ~IFullExceptionImpl
                            ();

protected:

private:

  void     operator=        (IFullExceptionImpl const&);


};

class IEmptyExceptionImpl :
  ICCEXCLASSSUPERCLASS (IEmptyException,\
                        TEmptyException)
public:

           IEmptyExceptionImpl
                            (char const*);

           IEmptyExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IEmptyExceptionImpl
                            (IEmptyExceptionImpl const&);

          ~IEmptyExceptionImpl
                            ();

protected:

private:

  void     operator=        (IEmptyExceptionImpl const&);


};

class INotEmptyExceptionImpl :
  ICCEXCLASSSUPERCLASS (INotEmptyException,\
                        TNotEmptyException)
public:

           INotEmptyExceptionImpl
                            (char const*);

           INotEmptyExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           INotEmptyExceptionImpl
                            (INotEmptyExceptionImpl const&);

          ~INotEmptyExceptionImpl
                            ();

protected:

private:

  void     operator=        (INotEmptyExceptionImpl const&);


};

class INotBoundedExceptionImpl :
  ICCEXCLASSSUPERCLASS (INotBoundedException,\
                        TNotBoundedException)
public:

           INotBoundedExceptionImpl
                            (char const*);

           INotBoundedExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           INotBoundedExceptionImpl
                            (INotBoundedExceptionImpl const&);

          ~INotBoundedExceptionImpl
                            ();

protected:

private:

  void     operator=        (INotBoundedExceptionImpl const&);


};

class ICursorInvalidExceptionImpl :
  ICCEXCLASSSUPERCLASS (ICursorInvalidException,\
                        TCursorInvalidException)
public:

           ICursorInvalidExceptionImpl
                            (char const*);

           ICursorInvalidExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICursorInvalidExceptionImpl
                            (ICursorInvalidExceptionImpl const&);

          ~ICursorInvalidExceptionImpl
                            ();

protected:

private:

  void     operator=        (ICursorInvalidExceptionImpl const&);


};

class IPositionInvalidExceptionImpl :
  ICCEXCLASSSUPERCLASS (IPositionInvalidException,\
                        TPositionInvalidException)
public:

           IPositionInvalidExceptionImpl
                            (char const*);

           IPositionInvalidExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IPositionInvalidExceptionImpl
                            (IPositionInvalidExceptionImpl const&);

          ~IPositionInvalidExceptionImpl
                            ();

protected:

private:

  void     operator=        (IPositionInvalidExceptionImpl const&);


};

class INotContainsKeyExceptionImpl :
  ICCEXCLASSSUPERCLASS (INotContainsKeyException,\
                        TNotContainsKeyException)
public:

           INotContainsKeyExceptionImpl
                            (char const*);

           INotContainsKeyExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           INotContainsKeyExceptionImpl
                            (INotContainsKeyExceptionImpl const&);

          ~INotContainsKeyExceptionImpl
                            ();

protected:

private:

  void     operator=        (INotContainsKeyExceptionImpl const&);


};

class IKeyAlreadyExistsExceptionImpl :
  ICCEXCLASSSUPERCLASS (IKeyAlreadyExistsException,\
                        TKeyAlreadyExistsException)
public:

           IKeyAlreadyExistsExceptionImpl
                            (char const*);

           IKeyAlreadyExistsExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IKeyAlreadyExistsExceptionImpl
                            (IKeyAlreadyExistsExceptionImpl const&);

          ~IKeyAlreadyExistsExceptionImpl
                            ();

protected:

private:

  void     operator=        (IKeyAlreadyExistsExceptionImpl const&);


};

class IRootAlreadyExistsExceptionImpl :
  ICCEXCLASSSUPERCLASS (IRootAlreadyExistsException,\
                        TRootAlreadyExistsException)
public:

           IRootAlreadyExistsExceptionImpl
                            (char const*);

           IRootAlreadyExistsExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IRootAlreadyExistsExceptionImpl
                            (IRootAlreadyExistsExceptionImpl const&);

          ~IRootAlreadyExistsExceptionImpl
                            ();

protected:

private:

  void     operator=        (IRootAlreadyExistsExceptionImpl const&);

};

class IChildAlreadyExistsExceptionImpl :
  ICCEXCLASSSUPERCLASS (IChildAlreadyExistsException,\
                        TChildAlreadyExistsException)
public:

           IChildAlreadyExistsExceptionImpl
                            (char const*);

           IChildAlreadyExistsExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IChildAlreadyExistsExceptionImpl
                            (IChildAlreadyExistsExceptionImpl const&);

          ~IChildAlreadyExistsExceptionImpl
                            ();

protected:

private:

  void     operator=        (IChildAlreadyExistsExceptionImpl const&);


};

class IIdenticalCollectionExceptionImpl :
  ICCEXCLASSSUPERCLASS (IIdenticalCollectionException,\
                        TIdenticalCollectionException)
public:

           IIdenticalCollectionExceptionImpl
                            (char const*);

           IIdenticalCollectionExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IIdenticalCollectionExceptionImpl
                            (IIdenticalCollectionExceptionImpl const&);

          ~IIdenticalCollectionExceptionImpl
                            ();

protected:

private:

  void     operator=        (IIdenticalCollectionExceptionImpl const&);


};

class IInvalidReplacementExceptionImpl :
  ICCEXCLASSSUPERCLASS (IInvalidReplacementException,\
                        TInvalidReplacementException)
public:

           IInvalidReplacementExceptionImpl
                            (char const*);

           IInvalidReplacementExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IInvalidReplacementExceptionImpl
                            (IInvalidReplacementExceptionImpl const&);

          ~IInvalidReplacementExceptionImpl
                            ();

protected:

private:

  void     operator=        (IInvalidReplacementExceptionImpl const&);


};

class ICyclicAttachExceptionImpl :
  ICCEXCLASSSUPERCLASS (ICyclicAttachException,\
                        TCyclicAttachException)
public:

           ICyclicAttachExceptionImpl
                            (char const*);

           ICyclicAttachExceptionImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           ICyclicAttachExceptionImpl
                            (ICyclicAttachExceptionImpl const&);

          ~ICyclicAttachExceptionImpl
                            ();

protected:

private:

  void     operator=        (ICyclicAttachExceptionImpl const&);


};

class IOutOfCollectionMemoryImpl :
  ICCEXCLASSSUPERCLASS (IOutOfCollectionMemory,\
                        TOutOfCollectionMemory)
public:

           IOutOfCollectionMemoryImpl
                            (char const*);

           IOutOfCollectionMemoryImpl
                            (char const*, char const*,
                             char const*, unsigned long,
                             unsigned long);

           IOutOfCollectionMemoryImpl
                            (IOutOfCollectionMemoryImpl const&);

          ~IOutOfCollectionMemoryImpl
                            ();

protected:

private:

  void     operator=        (IOutOfCollectionMemoryImpl const&);


};


#undef ITHROW
#undef IRETHROW
#undef ITRY
#undef IENDTRY
#undef ICATCH
#undef IENDCATCH

#if (INO_EXCEPTIONS_SUPPORT)

  #define ITHROW(exc)
  #define IRETHROW(exc)
  #define ITRY if (true)
  #define IENDTRY
  #define ICATCH(exc) if (false)
  #define IENDCATCH

#else

  #define ITHROW(exc) throw exc
  #define IRETHROW(exc) throw
  #define ITRY try
  #define IENDTRY
  #define ICATCH(exc) catch (exc)
  #define IENDCATCH

#endif

#if ! defined (IASSERT)
#define IASSERT(exp)
#endif

#define ICHECK(pre, exc, cn, mn, txt)\
  { if (! (pre))\
      throw exc (cn, mn, __FILE__, __LINE__, txt);\
  }

#define ICHECK_Memory(Class, Method) \
  ICHECK (result != 0,\
          IOutOfCollectionMemoryImpl,\
          Class, Method, IC_OUT_OF_COLLECTION_MEMORY)

#define ICHECK_IsEmpty(Class, Method) \
  ICHECK (! IsEmpty (),\
          IEmptyExceptionImpl,\
          Class, Method, IC_COLLECTION_IS_EMPTY)

#define ICHECK_IsFor(Class, Method) \
  ICHECK (cursor.IsFor (*this),\
          ICursorInvalidExceptionImpl,\
          Class, Method, IC_CURSOR_NOT_FOR_THIS)

#define ICHECK_IsForThat(Class, Method) \
  ICHECK (thatCursor.IsFor (tree),\
          ICursorInvalidExceptionImpl,\
          Class, Method, IC_CURSOR_NOT_FOR_GIVEN)

#define ICHECK_Identical(Class, Method) \
  ICHECK (this != &collection,\
          IIdenticalCollectionExceptionImpl,\
          Class, Method, IC_IDENTICAL_COLLECTION)

#define ICHECK_IsValid(Class, Method) \
  ICHECK (cursor.IsValid (),\
          ICursorInvalidExceptionImpl,\
          Class, Method, IC_INVALID_CURSOR)

#define ICHECK_IsThatValid(Class, Method) \
  ICHECK (thatCursor.IsValid (),\
          ICursorInvalidExceptionImpl,\
          Class, Method, IC_INVALID_CURSOR)

#define ICHECK_Cursor(Class, Method) \
  ICHECK (CheckCursor (cursor),\
          ICursorInvalidExceptionImpl,\
          Class, Method, IC_CURSOR_NOT_CONTAINED)

#define ICHECK_ThatCursor(Class, Method) \
  ICHECK (tree.CheckCursor (thatCursor),\
          ICursorInvalidExceptionImpl,\
          Class, Method, IC_CURSOR_NOT_CONTAINED)

#define ICHECK_Child(Class, Method) \
  ICHECK (CheckChild (cursor, position),\
          IChildAlreadyExistsExceptionImpl,\
          Class, Method, IC_CHILD_ALREADY_EXISTS)

#define ICHECK_Root(Class, Method) \
  ICHECK (IsEmpty (),\
          IRootAlreadyExistsExceptionImpl,\
          Class, Method, IC_ROOT_ALREADY_EXISTS)

#define ICHECK_Position(Class, Method) \
  ICHECK (1 <= position && position <= NumberOfElements (),\
          IPositionInvalidExceptionImpl,\
          Class, Method, IC_INVALID_POSITION)

#define ICHECK_Position2(Class, Method) \
  ICHECK (1 <= position && position <= NumberOfElements () + 1,\
          IPositionInvalidExceptionImpl,\
          Class, Method, IC_INVALID_POSITION)

#define ICHECK_Position3(Class, Method) \
  ICHECK (1 <= position && position <= NumberOfChildren (),\
          IPositionInvalidExceptionImpl,\
          Class, Method, IC_INVALID_POSITION)

#define ICHECK_ContainsKey(Class, Method) \
  ICHECK (LocateElementWithKey (key, cursor),\
          INotContainsKeyExceptionImpl,\
          Class, Method, IC_KEY_NOT_CONTAINED)

#define ICHECK_NotBounded(Class, Method) \
  ICHECK (false,\
          INotBoundedExceptionImpl,\
          Class, Method, IC_NOT_BOUNDED)

#define ICHECK_Replacement(Class, Method) \
  ICHECK (CheckReplacement (cursor, element),\
          IInvalidReplacementExceptionImpl,\
          Class, Method, IC_INVALID_REPLACEMENT)

#define ICHECK_Equality(Class, Method) \
  ICHECK (Contains (element),\
          IKeyAlreadyExistsExceptionImpl,\
          Class, Method, IC_KEY_ALREADY_EXISTS)

#define ICHECK_Cycle(Class, Method) \
  ICHECK (this != &tree,\
          ICyclicAttachExceptionImpl,\
          Class, Method, IC_CYCLIC_CHILD_ATTACHMENT)

#define ICHECK_Cycle2(Class, Method) \
  ICHECK (this != &tree || \
          ! CheckCursor (cursor, thatCursor),\
          ICyclicAttachExceptionImpl,\
          Class, Method, IC_CYCLIC_CHILD_ATTACHMENT)

#pragma SOMAsDefault (pop)


#pragma pack ()
#pragma info (restore)

#endif
