/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIHPDIL_H
#define _IIHPDIL_H

#include <iihpseq.h>


#include <iiseqdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IHeapOnSequenceImpl
         <ISequenceAsDilTableImpl> IHeapAsDilTableImpl;

typedef IAHeapOnSequenceOps
         <ISequenceAsDilTableImpl> IAHeapAsDilTableOps;

template <class Element, class ElementOps, class Implementation>
class IHeapAsDilTableOps :
  public IAHeapAsDilTableOps {

  typedef  IHeapAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, ISequenceAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IHeapAsDilTableOps
                           (INumber);

           IHeapAsDilTableOps
                           (INumber, void*);

           IHeapAsDilTableOps
                           (IHeapAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IHeapAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator ISequenceAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iihpdil.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
