/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIHPLST_H
#define _IIHPLST_H

#include <iihpseq.h>


#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IHeapOnSequenceImpl
         <ISequenceAsListImpl> IHeapAsListImpl;

typedef IAHeapOnSequenceOps
         <ISequenceAsListImpl> IAHeapAsListOps;

template <class Element, class ElementOps, class Implementation>
class IHeapAsListOps :
  public IAHeapAsListOps {

  typedef  IHeapAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IHeapAsListOps
                           (INumber);

           IHeapAsListOps
                           (INumber, void*);

           IHeapAsListOps
                           (IHeapAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IHeapAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iihplst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
