/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKBKSB_H
#define _IIKBKSB_H

#include <iiakb.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IKeyBagOnKeySortedBagMngCursorImpl;

template <class Base>
class IKeyBagOnKeySortedBagImpl;

template <class Base>
class IKeyBagOnKeySortedBagMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IKeyBagOnKeySortedBagMngCursorImpl
                            (IKeyBagOnKeySortedBagImpl <Base> const&);

          ~IKeyBagOnKeySortedBagMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IBagOnKeyBagImpl;

template <class Base>
class IAKeyBagOnKeySortedBagOps;

template <class Base>
class IKeyBagOnKeySortedBagImpl : public IAKeyBagImpl {

  typedef  IAKeyBagImpl Inherited;

  typedef  IKeyBagOnKeySortedBagImpl <Base> Self;

public:

  typedef  IAKeyBagOnKeySortedBagOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IKeyBagOnKeySortedBagMngCursorImpl <Base> MngCursor;

           IKeyBagOnKeySortedBagImpl
                            (Ops&, INumber);

           IKeyBagOnKeySortedBagImpl
                            (Ops&,
                             IKeyBagOnKeySortedBagImpl <Base> const&);

          ~IKeyBagOnKeySortedBagImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const* ) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  void*    Key              (void const*) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     operator=        (IKeyBagOnKeySortedBagImpl <Base> const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualKeys        (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IKeyBagOnKeySortedBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IKeyBagOnKeySortedBagImpl <Base> const&);

  friend
  class    IKeyBagOnKeySortedBagMngCursorImpl <Base>;

  friend
  class    IKeyBagOnKeySortedBagImpl <Base>;

  friend
  class    IBagOnKeyBagImpl <Self>;


};

template <class Base>
class IAKeyBagOnKeySortedBagOps {
public:

  virtual ~IAKeyBagOnKeySortedBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iikbksb.inl>


#pragma info (restore)
#pragma pack ()

#endif
