/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKBTAB_H
#define _IIKBTAB_H

#include <iikbksb.h>


#include <iiksbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeyBagOnKeySortedBagImpl
         <IKeySortedBagAsTableImpl> IKeyBagAsTableImpl;

typedef IAKeyBagOnKeySortedBagOps
         <IKeySortedBagAsTableImpl> IAKeyBagAsTableOps;

template <class Element, class Key,
          class ElementOps, class Implementation>
class IKeyBagAsTableOps :
  public IAKeyBagAsTableOps {

  typedef  IKeyBagAsTableOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsTableOps
            <Element, Key,
             ElementOps, IKeySortedBagAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeyBagAsTableOps
                           (INumber);

           IKeyBagAsTableOps
                           (INumber, void*);

           IKeyBagAsTableOps
                           (IKeyBagAsTableOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeyBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iikbtab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
