/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSBSEQ_H
#define _IIKSBSEQ_H

#include <iiaksb.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IKeySortedBagOnSequenceMngCursorImpl;

template <class Base>
class IKeySortedBagOnSequenceImpl;

template <class Base>
class IKeySortedBagOnSequenceMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IKeySortedBagOnSequenceMngCursorImpl
                            (IKeySortedBagOnSequenceImpl <Base> const&);

          ~IKeySortedBagOnSequenceMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class ISortedRelationOnKeySortedBagImpl;

template <class Base>
class IKeyBagOnKeySortedBagImpl;

template <class Base>
class IAKeySortedBagOnSequenceOps;

template <class Base>
class IKeySortedBagOnSequenceImpl : public IAKeySortedBagImpl {

  typedef  IAKeySortedBagImpl Inherited;

  typedef  IKeySortedBagOnSequenceImpl <Base> Self;

public:

  typedef  IAKeySortedBagOnSequenceOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IKeySortedBagOnSequenceMngCursorImpl <Base> MngCursor;

           IKeySortedBagOnSequenceImpl
                            (Ops&, INumber);

           IKeySortedBagOnSequenceImpl
                            (Ops&,
                             IKeySortedBagOnSequenceImpl <Base> const&);

          ~IKeySortedBagOnSequenceImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  IBoolean SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (IKeySortedBagOnSequenceImpl <Base> const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  long     CompareKeys      (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  void const*
           ivKey;


  struct Predicate {

    typedef  IKeySortedBagOnSequenceImpl <Base> KSB;

    static
    IBoolean IsEqual          (void const*, void*);

  };


  static
  Base&    BaseOf           (IKeySortedBagOnSequenceImpl <Base> const&);

  IBoolean LocateKey        (void const*, ICursorImpl&) const;

  IBoolean LocateNextKey    (void const*, ICursorImpl&) const;

  static
  Ops&     OpsOf            (IKeySortedBagOnSequenceImpl <Base> const&);

  friend
  struct   Predicate;

  friend
  class    IKeySortedBagOnSequenceMngCursorImpl <Base>;

  friend
  class    ISortedRelationOnKeySortedBagImpl <Self>;

  friend
  class    IKeyBagOnKeySortedBagImpl <Self>;


};

template <class Base>
class IAKeySortedBagOnSequenceOps {
public:

  virtual ~IAKeySortedBagOnSequenceOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  long     CompareKeys      (void const*, void const*,
                             IArgType) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iiksbseq.inl>


#pragma info (restore)
#pragma pack ()

#endif
