/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSBTAB_H
#define _IIKSBTAB_H

#include <iiksbseq.h>


#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySortedBagOnSequenceImpl
         <ISequenceAsTableImpl> IKeySortedBagAsTableImpl;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IKeySortedBagAsTableOps :
  public IAKeySortedBagOnSequenceOps <ISequenceAsTableImpl> {

  typedef  IKeySortedBagAsTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedBagAsTableOps
                           (INumber);

           IKeySortedBagAsTableOps
                           (INumber, void*);

           IKeySortedBagAsTableOps
                           (IKeySortedBagAsTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiksbtab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
