/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSKSS_H
#define _IIKSKSS_H

#include <iiaks.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class IKeySetOnKeySortedSetMngCursorImpl;

template <class Base>
class IKeySetOnKeySortedSetImpl;

template <class Base>
class IKeySetOnKeySortedSetMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           IKeySetOnKeySortedSetMngCursorImpl
                            (IKeySetOnKeySortedSetImpl <Base> const&);

          ~IKeySetOnKeySortedSetMngCursorImpl
                            ();

protected:

private:


};

template <class Base>
class IBagOnKeySetImpl;

template <class Base>
class IAKeySetOnKeySortedSetOps;

template <class Base>
class IKeySetOnKeySortedSetImpl : public IAKeySetImpl {

  typedef  IAKeySetImpl Inherited;

  typedef  IKeySetOnKeySortedSetImpl <Base> Self;

public:

  typedef  IAKeySetOnKeySortedSetOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  IKeySetOnKeySortedSetMngCursorImpl <Base> MngCursor;

           IKeySetOnKeySortedSetImpl
                            (Ops&, INumber);

           IKeySetOnKeySortedSetImpl
                            (Ops&,
                             IKeySetOnKeySortedSetImpl <Base> const&);

          ~IKeySetOnKeySortedSetImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const* ) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  IBoolean ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFull           () const;

  void*    Key              (void const*) const;

  IBoolean LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     operator=        (IKeySetOnKeySortedSetImpl <Base> const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  IBoolean EqualKeys        (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IKeySetOnKeySortedSetImpl <Base> const&);

  static
  Ops&     OpsOf            (IKeySetOnKeySortedSetImpl <Base> const&);

  friend
  class    IKeySetOnKeySortedSetMngCursorImpl <Base>;

  friend
  class    IKeySetOnKeySortedSetImpl <Base>;

  friend
  class    IBagOnKeySetImpl <Self>;


};

template <class Base>
class IAKeySetOnKeySortedSetOps {
public:

  virtual ~IAKeySetOnKeySortedSetOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iikskss.inl>


#pragma info (restore)
#pragma pack ()

#endif
