/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSSLST_H
#define _IIKSSLST_H

#include <iikssseq.h>


#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySortedSetOnSequenceImpl
         <ISequenceAsListImpl> IKeySortedSetAsListImpl;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IKeySortedSetAsListOps :
  public IAKeySortedSetOnSequenceOps <ISequenceAsListImpl> {

  typedef  IKeySortedSetAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedSetAsListOps
                           (INumber);

           IKeySortedSetAsListOps
                           (INumber, void*);

           IKeySortedSetAsListOps
                           (IKeySortedSetAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedSetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iiksslst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
