/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IKeySortedSetAsTableOps
// ---

// public members

template <class Element, class Key,
          class ElementOps, class Implementation>
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
IKeySortedSetAsTableOps (INumber numberOfElements)
: ivElementOps (),
  ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
IKeySortedSetAsTableOps (INumber numberOfElements, void* opsArg)
: ivElementOps (opsArg),
  ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
IKeySortedSetAsTableOps
  (IKeySortedSetAsTableOps
    <Element, Key, ElementOps, Implementation> const& collection)
: ivElementOps (collection.ivElementOps),
  ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
~IKeySortedSetAsTableOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IACollectionImpl*
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
long
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
CompareKeys (void const* arg1, void const* arg2, IArgType argType) const
{ long comp = 0;
  switch (argType) {
    case kElementElement: {
      comp = ivElementOps.keyOps.Compare
        (ivElementOps.Key (*(Element const*)arg1),
         ivElementOps.Key (*(Element const*)arg2));
      break;
    }
    case kElementKey: {
      comp = ivElementOps.keyOps.Compare
        (ivElementOps.Key (*(Element const*)arg1),
         IKeyForOps ((Key const*)arg2));
      break;
    }
    case kKeyKey: {
      comp = ivElementOps.keyOps.Compare
        (IKeyForOps ((Key const*)arg1), IKeyForOps ((Key const*)arg2));
    }
  }
  return comp;
}

template <class Element, class _Key,
          class ElementOps, class Implementation>
void*
IKeySortedSetAsTableOps <Element, _Key, ElementOps, Implementation>::
Key (void const* element) const
{ return IKeyFromOps (ivElementOps.Key (*(Element const*)element));
}

template <class Element, class Key,
          class ElementOps, class Implementation>
TStream&
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
operator<<= (TStream& fromWhere)
{ return (ivElementOps <<= fromWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
TStream&
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
operator>>= (TStream& toWhere) const
{ return (ivElementOps >>= toWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
operator ISequenceAsTableImpl& ()
{ return *(ISequenceAsTableImpl*)ivBase;
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IKeySortedSetAsTableOps <Element, Key, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
