/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIKSTAB_H
#define _IIKSTAB_H

#include <iikskss.h>


#include <iiksstab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsTableImpl> IKeySetAsTableImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsTableImpl> IAKeySetAsTableOps;

template <class Element, class Key,
          class ElementOps, class Implementation>
class IKeySetAsTableOps :
  public IAKeySetAsTableOps {

  typedef  IKeySetAsTableOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsTableOps
            <Element, Key,
             ElementOps, IKeySortedSetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsTableOps
                           (INumber);

           IKeySetAsTableOps
                           (INumber, void*);

           IKeySetAsTableOps
                           (IKeySetAsTableOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iikstab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
