/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIMAPHSH_H
#define _IIMAPHSH_H

#include <iimapks.h>


#include <iikshsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IMapOnKeySetImpl
         <IKeySetAsHshTableImpl> IMapAsHshTableImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsHshTableImpl> IAMapAsAsHshTableOps;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IMapAsHshTableOps :
  public IAMapAsAsHshTableOps {

  typedef  IMapAsHshTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsHshTableOps
            <Element, _Key,
             ElementOps, IKeySetAsHshTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsHshTableOps
                           (INumber);

           IMapAsHshTableOps
                           (INumber, void*);

           IMapAsHshTableOps
                           (IMapAsHshTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsHshTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  IBoolean EqualElements    (void const*, void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator IKeySetAsHshTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iimaphsh.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
