/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIRELLST_H
#define _IIRELLST_H

#include <iirelkb.h>


#include <iikblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef IRelationOnKeyBagImpl
         <IKeyBagAsListImpl> IRelationAsListImpl;

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IRelationAsListOps :
  public IARelationOnKeyBagOps
          <IKeyBagAsListImpl> {

  typedef  IRelationAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeyBagAsListOps
            <Element, _Key,
             ElementOps, IKeyBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IRelationAsListOps
                           (INumber);

           IRelationAsListOps
                           (INumber, void*);

           IRelationAsListOps
                           (IRelationAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IRelationAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  IBoolean EqualElements   (void const*, void const*) const;

  TStream& operator<<=     (TStream&);

  TStream& operator>>=     (TStream&) const;

           operator IKeyBagAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iirellst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
