/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IRelationAsTableOps
// ---

// public members

template <class Element, class Key,
          class ElementOps, class Implementation>
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
IRelationAsTableOps (INumber numberOfElements)
: ivElementOps (),
  ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IRelationAsTableOps
  <Element, Key, ElementOps, Implementation>::
IRelationAsTableOps (INumber numberOfElements, void* opsArg)
: ivElementOps (opsArg),
  ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
IRelationAsTableOps
  (IRelationAsTableOps
    <Element, Key, ElementOps, Implementation> const& collection)
: ivElementOps (collection.ivElementOps),
  ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
~IRelationAsTableOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IACollectionImpl*
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IBoolean
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
EqualElements (void const* element1, void const* element2) const
{ return ivElementOps.Equal (*(Element const*)element1,
                             *(Element const*)element2);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
TStream&
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
operator<<= (TStream& fromWhere)
{ return (ivElementOps <<= fromWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
TStream&
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
operator>>= (TStream& toWhere) const
{ return (ivElementOps >>= toWhere);
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
operator IKeyBagAsTableImpl& ()
{ return *(IKeyBagAsTableImpl*) ivBase;
}

template <class Element, class Key,
          class ElementOps, class Implementation>
IRelationAsTableOps
 <Element, Key, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
