/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// ISortedBagAsTableOps
// ---

// public members

template <class Element, class ElementOps, class Implementation>
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
ISortedBagAsTableOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
ISortedBagAsTableOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
ISortedBagAsTableOps
  (ISortedBagAsTableOps
    <Element, ElementOps, Implementation> const& collection)
: Inherited (__isDTSClass (Element)),
  ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
~ISortedBagAsTableOps ()
{
}

template <class Element, class ElementOps, class Implementation>
IACollectionImpl*
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
operator IKeySortedBagAsTableImpl& ()
{ return *(IKeySortedBagAsTableImpl*)ivBase;
}

template <class Element, class ElementOps, class Implementation>
ISortedBagAsTableOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
