/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISEQDIL_H
#define _IISEQDIL_H

#include <iiaseq.h>
#include <iitable.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
struct ISequenceAsDilTableNodeImpl {

  void*    ivPtr;

  Element  ivElement;

           ISequenceAsDilTableNodeImpl
                            (Element const&);

          ~ISequenceAsDilTableNodeImpl
                            ();


};

struct IDilTableImpl : public ITableImpl {

  typedef  ISequenceAsDilTableNodeImpl <void*> Node;

  void*    ivUnused;

  void*    ElementAtIndex   (INumber) const;

  void     GetUnused        (INumber);

  void*&   PtrAtIndex       (INumber) const;

  void     PutUnused        (INumber);

  void     RemoveAtIndex    (INumber);

};

#pragma SOMAsDefault (pop)
#pragma SOMAsDefault (off)

class ISequenceAsDilTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsDilTableCursorImpl Self;

public:

           ISequenceAsDilTableCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsDilTableCursorImpl
                            (ISequenceAsDilTableCursorImpl const&);

          ~ISequenceAsDilTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  IBoolean IsInBetween      () const;

  IBoolean IsValid          () const;

  void     operator=        (ISequenceAsDilTableCursorImpl const&);

  IBoolean operator==       (ICursorImpl const&) const;

protected:

private:

  INumber  ivIndex;

  friend
  class    ISequenceAsDilTableImpl;


};


class IASequenceAsDilTableOps;

class ISequenceAsDilTableImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsDilTableImpl Self;

public:

  typedef  IASequenceAsDilTableOps Ops;

  typedef  ISequenceAsDilTableCursorImpl Cursor;

  typedef  ISequenceAsDilTableCursorImpl MngCursor;

           ISequenceAsDilTableImpl
                            (Ops&, INumber);

           ISequenceAsDilTableImpl
                            (Ops&, ISequenceAsDilTableImpl const&);

          ~ISequenceAsDilTableImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition position, void const*);

  void     Reverse          ();

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsDilTableImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&) const;

  void     ConstructNode    (void*, void const*) const;

  void     DeleteNodes      (void*) const;

  void     DestroyNode      (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  IDilTableImpl
           ivTable;

  virtual
  void     CopyFrom         (ISequenceAsDilTableImpl const&);

  void*    ElementOf        (void const*) const;

  void     GrowBy           (INumber);

  static
  INumber& IndexOf          (ICursorImpl const&);

  void     Initialize       (INumber);

  static
  IBoolean IsInBetween      (ICursorImpl const&);

  IBoolean IsRemoved        (INumber) const;

  void     MakeFree         (INumber&);

  static
  INumber& NextIndexOf      (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsDilTableImpl const&);

  IPosition
           PositionAtIndex  (INumber) const;

  static
  INumber& PreviousIndexOf  (ICursorImpl const&);

  void     RemoveAtIndex    (INumber);

  void     SetInBetween     (MngCursor&) const;

  IBoolean SetToNextIndex   (INumber&) const;

  IBoolean SetToPreviousIndex
                            (INumber&) const;

  void     UpdateMngCursorsForCopyFrom
                            (INumber, INumber) const;

  void     UpdateMngCursorsForGrowBy
                            () const;

  void     UpdateMngCursorsForRemoveOf
                            (INumber) const;

  void     UpdateMngCursorsForSwap
                            (INumber, INumber) const;

  friend
  class    ISequenceAsDilTableMngCursorImpl;


};

class IASequenceAsDilTableOps {
public:

  virtual ~IASequenceAsDilTableOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNodes      (INumber, size_t&) const = 0;

  virtual
  void     ConstructNode    (void*, void const*) const = 0;

  virtual
  void     DeleteNodes      (void*) const = 0;

  virtual
  void     DestroyNode      (void*) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

           IASequenceAsDilTableOps
                            (IBoolean);

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    ISequenceAsDilTableImpl;


};

template <class Element, class ElementOps, class Implementation>
class ISequenceAsDilTableOps : public IASequenceAsDilTableOps {

  typedef  IASequenceAsDilTableOps Inherited;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsDilTableOps
                            (INumber);

           ISequenceAsDilTableOps
                            (INumber, void*);

           ISequenceAsDilTableOps
                            (ISequenceAsDilTableOps
                              <Element, ElementOps,
                               Implementation> const&);

          ~ISequenceAsDilTableOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNodes      (INumber, size_t&) const;

  void     ConstructNode    (void*, void const*) const;

  void     DeleteNodes      (void*) const;

  void     DestroyNode      (void*) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iiseqdil.inl>

#if ! defined (__TEMPINC__)
#include <iiseqdil.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
