/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---------------------------
// ISequenceAsDilTableNodeImpl
// ---------------------------

// public members

template <class Element>
inline
ISequenceAsDilTableNodeImpl <Element>::
ISequenceAsDilTableNodeImpl (Element const& element)
: ivElement (element)
{
}

template <class Element>
inline
ISequenceAsDilTableNodeImpl <Element>::
~ISequenceAsDilTableNodeImpl ()
{
}

// -----------------------------
// ISequenceAsDilTableCursorImpl
// -----------------------------

// public members

inline void
ISequenceAsDilTableCursorImpl::
Invalidate ()
{ ivIndex = 0;
}

inline IBoolean
ISequenceAsDilTableCursorImpl::
IsInBetween () const
{ return false;
}

inline IBoolean
ISequenceAsDilTableCursorImpl::
IsValid () const
{ return (ivIndex != 0);
}

inline void
ISequenceAsDilTableCursorImpl::
operator= (ISequenceAsDilTableCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivIndex = cursor.ivIndex;
}

inline IBoolean
ISequenceAsDilTableCursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivIndex == ((Self const&)cursor).ivIndex);
}

// -----------------------
// ISequenceAsDilTableImpl
// -----------------------

// public members


// -----------------------
// IASequenceAsDilTableOps
// -----------------------

// public members

inline
IASequenceAsDilTableOps::
~IASequenceAsDilTableOps ()
{
}

// protected members

inline
IASequenceAsDilTableOps::
IASequenceAsDilTableOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}
