/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <new.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ------------------
// ISequenceAsListOps
// ------------------

// public members

template <class Element, class ElementOps, class Implementation>
ISequenceAsListOps <Element, ElementOps, Implementation>::
ISequenceAsListOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsListOps <Element, ElementOps, Implementation>::
ISequenceAsListOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsListOps <Element, ElementOps, Implementation>::
ISequenceAsListOps
  (ISequenceAsListOps <Element, ElementOps,
                       Implementation> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsListOps <Element, ElementOps, Implementation>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class ElementOps, class Implementation>
IACollectionImpl*
ISequenceAsListOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsListOps <Element, ElementOps, Implementation>::
CreateNode (void const* element) const
{ void* node = ivElementOps.Allocate (sizeof (Node)
#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif
                                     );
  return new (ivImpl.CheckPointer (node))
              Node (*(Element const*)element);
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsListOps <Element, ElementOps, Implementation>::
DeleteNode (void* node) const
{ ((Node*)node)->~Node ();
  ivElementOps.Deallocate (node
#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif
                          );
}

template <class Element, class ElementOps, class Implementation>
void*
ISequenceAsListOps <Element, ElementOps, Implementation>::
StreamIn (TStream& fromWhere) const
{ Element* element = ivElementOps.GetStreamable ();
  ivElementOps.StreamIn (*element, fromWhere);
  return element;
}

template <class Element, class ElementOps, class Implementation>
void
ISequenceAsListOps <Element, ElementOps, Implementation>::
StreamOut (void const* element, TStream& toWhere) const
{ ivElementOps.StreamOut (*(Element const*)element, toWhere);
}

template <class Element, class ElementOps, class Implementation>
TStream&
ISequenceAsListOps <Element, ElementOps, Implementation>::
operator<<= (TStream& fromWhere)
{ return (ivElementOps <<= fromWhere);
}

template <class Element, class ElementOps, class Implementation>
TStream&
ISequenceAsListOps <Element, ElementOps, Implementation>::
operator>>= (TStream& toWhere) const
{ return (ivElementOps >>= toWhere);
}

template <class Element, class ElementOps, class Implementation>
ISequenceAsListOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}

#pragma info (restore)
#pragma pack ()
