/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// -----------------------
// ISequenceAsListNodeImpl
// -----------------------

// public members

template <class Element>
inline
ISequenceAsListNodeImpl <Element>::
ISequenceAsListNodeImpl (Element const& element)
: ivNext (0), ivPrevious (0), ivElement (element)
{
}

template <class Element>
inline
ISequenceAsListNodeImpl <Element>::
~ISequenceAsListNodeImpl ()
{
}

// -------------------------
// ISequenceAsListCursorImpl
// -------------------------

// public members

inline void
ISequenceAsListCursorImpl::
Invalidate ()
{ ivNode = 0;
}

inline IBoolean
ISequenceAsListCursorImpl::
IsInBetween () const
{ return false;
}

inline IBoolean
ISequenceAsListCursorImpl::
IsValid () const
{ return (ivNode != 0);
}

inline void
ISequenceAsListCursorImpl::
operator= (ISequenceAsListCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivNode = cursor.ivNode;
}

inline IBoolean
ISequenceAsListCursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivNode == ((Self const&)cursor).ivNode);
}

// -------------------
// ISequenceAsListImpl
// -------------------

// public members


// -------------------
// IASequenceAsListOps
// -------------------

// public members

inline
IASequenceAsListOps::
~IASequenceAsListOps ()
{
}

// protected members

inline
IASequenceAsListOps::
IASequenceAsListOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}
