/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISEQTAB_H
#define _IISEQTAB_H

#include <iiaseq.h>
#include <iitable.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
struct ISequenceAsTableNodeImpl {

  Element  ivElement;

           ISequenceAsTableNodeImpl
                            (Element const&);

          ~ISequenceAsTableNodeImpl
                            ();


};

#pragma SOMAsDefault (pop)
#pragma SOMAsDefault (off)

class ISequenceAsTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsTableCursorImpl Self;

public:

           ISequenceAsTableCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsTableCursorImpl
                            (ISequenceAsTableCursorImpl const&);

          ~ISequenceAsTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  IBoolean IsInBetween      () const;

  IBoolean IsValid          () const;

  void     operator=        (ISequenceAsTableCursorImpl const&);

  IBoolean operator==       (ICursorImpl const&) const;

protected:

private:

  INumber  ivIndex;

  friend
  class    ISequenceAsTableImpl;


};


class IASequenceAsTableOps;

class ISequenceAsTableImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsTableImpl Self;

public:

  typedef  IASequenceAsTableOps Ops;

  typedef  ISequenceAsTableCursorImpl Cursor;

  typedef  ISequenceAsTableCursorImpl MngCursor;

           ISequenceAsTableImpl
                            (Ops&, INumber);

           ISequenceAsTableImpl
                            (Ops&,
                             ISequenceAsTableImpl const&);

          ~ISequenceAsTableImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  void     Reverse          ();

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsTableImpl const&);

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

  void     Assign           (void*, void const*) const;

  void     BlockLeft        (INumber, INumber);

  void     BlockRight       (INumber, INumber);

  void     CopyFrom         (ITableImpl const&);

  void     ConstructNode    (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&);

  void     DeleteNodes      (void*);

  void     DestroyNodes     (void*, INumber = 1) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  void     Swap             (INumber, INumber) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  ITableImpl
           ivTable;

  void     GrowBy           (INumber);

  void*    ElementOf        (void const*) const;

  static
  INumber& IndexOf          (ICursorImpl const&);

  void     Initialize       (INumber);

  static
  IBoolean IsInBetween      (ICursorImpl const&);

  static
  INumber& NextIndexOf      (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsTableImpl const&);

  static
  INumber& PreviousIndexOf  (ICursorImpl const&);

  void     RemoveAtIndex    (INumber);

  void     SetInBetween     (MngCursor&) const;

  void     Quicksort        (ICompFunc, void*, INumber, INumber);

  void     UpdateMngCursorsForAssign
                            (INumber, INumber) const;

  void     UpdateMngCursorsForCopyFrom
                            (INumber, INumber) const;

  void     UpdateMngCursorsForGrowBy
                            () const;

  void     UpdateMngCursorsForPredRemove
                            (INumber, INumber) const;

  void     UpdateMngCursorsForRemoveOf
                            (INumber) const;

  void     UpdateMngCursorsForShiftLeftOf
                            (INumber) const;

  void     UpdateMngCursorsForShiftRightOf
                            (INumber) const;

  void     UpdateMngCursorsForSwap
                            (INumber, INumber) const;

  friend
  class    ISequenceAsTableMngCursorImpl;

  friend
  class    IASequenceAsTableOps;


};

class IASequenceAsTableOps {
public:

  virtual ~IASequenceAsTableOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  void     BlockLeft        (INumber, INumber) = 0;

  virtual
  void     BlockRight       (INumber, INumber) = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void     CopyFrom         (ITableImpl const&) = 0;

  virtual
  void     ConstructNode    (void*, void const*) const = 0;

  virtual
  void*    CreateNodes      (INumber, size_t&) = 0;

  virtual
  void     DeleteNodes      (void*) = 0;

  virtual
  void     DestroyNodes     (void*, INumber = 1) const = 0;

  virtual
  void*    StreamIn         (TStream&) const = 0;

  virtual
  void     StreamOut        (void const*, TStream&) const = 0;

  virtual
  void     Swap             (INumber, INumber) const = 0;

  virtual
  TStream& operator<<=      (TStream&) = 0;

  virtual
  TStream& operator>>=      (TStream&) const = 0;

protected:

           IASequenceAsTableOps
                            (IBoolean);

  static
  ITableImpl&
           TableOf          (ISequenceAsTableImpl const&);

  void     UpdateMngCursorsForAssign
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

  void     UpdateMngCursorsForCopyFrom
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

  void     UpdateMngCursorsForPredRemove
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

  void     UpdateMngCursorsForRemoveOf
                            (ISequenceAsTableImpl const&,
                             INumber) const;

  void     UpdateMngCursorsForShiftLeftOf
                            (ISequenceAsTableImpl const&,
                             INumber) const;

  void     UpdateMngCursorsForShiftRightOf
                            (ISequenceAsTableImpl const&,
                             INumber) const;

  void     UpdateMngCursorsForSwap
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

private:

  IBoolean ivContainsDTSObjects;

  friend
  class    ISequenceAsTableImpl;


};

template <class Element, class ElementOps, class Implementation>
class ISequenceAsTableOps : public IASequenceAsTableOps {

  typedef  IASequenceAsTableOps Inherited;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsTableOps
                            (INumber);

           ISequenceAsTableOps
                            (INumber, void*);

           ISequenceAsTableOps
                            (ISequenceAsTableOps
                              <Element, ElementOps,
                               Implementation> const&);

          ~ISequenceAsTableOps
                            ();

  void     Assign           (void*, void const*) const;

  void     BlockLeft        (INumber, INumber);

  void     BlockRight       (INumber, INumber);

  IACollectionImpl*
           Clone            () const;

  void     CopyFrom         (ITableImpl const&);

  void     ConstructNode    (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&);

  void     DeleteNodes      (void*);

  void     DestroyNodes     (void*, INumber) const;

  void*    StreamIn         (TStream&) const;

  void     StreamOut        (void const*, TStream&) const;

  void     Swap             (INumber, INumber) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

           operator Implementation*
                            ();


protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#include <iiseqtab.inl>

#if ! defined (__TEMPINC__)
#include <iiseqtab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
