/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ------------------------
// ISequenceAsTableNodeImpl
// ------------------------

// public member

template <class Element>
inline
ISequenceAsTableNodeImpl <Element>::
ISequenceAsTableNodeImpl (Element const& element)
: ivElement (element)
{
}

template <class Element>
inline
ISequenceAsTableNodeImpl <Element>::
~ISequenceAsTableNodeImpl ()
{
}

// --------------------------
// ISequenceAsTableCursorImpl
// --------------------------

// public members

inline void
ISequenceAsTableCursorImpl::
Invalidate ()
{ ivIndex = 0;
}

inline IBoolean
ISequenceAsTableCursorImpl::
IsInBetween () const
{ return false;
}

inline IBoolean
ISequenceAsTableCursorImpl::
IsValid () const
{ return (ivIndex != 0);
}

inline void
ISequenceAsTableCursorImpl::
operator= (ISequenceAsTableCursorImpl const& cursor)
{ Inherited::operator= (cursor);
  ivIndex = cursor.ivIndex;
}

inline IBoolean
ISequenceAsTableCursorImpl::
operator== (ICursorImpl const& cursor) const
{ return (Inherited::operator== (cursor) &&
          ivIndex == ((Self const&)cursor).ivIndex);
}

// --------------------
// ISequenceAsTableImpl
// --------------------

// public members


// --------------------
// IASequenceAsTableOps
// --------------------

// public members

inline
IASequenceAsTableOps::
~IASequenceAsTableOps ()
{
}

// protected members

inline
IASequenceAsTableOps::
IASequenceAsTableOps (IBoolean containsDTSObjects)
: ivContainsDTSObjects (containsDTSObjects)
{
}

inline ITableImpl&
IASequenceAsTableOps::
TableOf (ISequenceAsTableImpl const& collection)
{ return ((ISequenceAsTableImpl&)collection).ivTable;
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForAssign (ISequenceAsTableImpl const& collection,
                           INumber target, INumber source) const
{ collection.UpdateMngCursorsForAssign (target, source);
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForCopyFrom (ISequenceAsTableImpl const& collection,
                             INumber fromIndex, INumber toIndex) const
{ collection.UpdateMngCursorsForCopyFrom (fromIndex, toIndex);
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForPredRemove (ISequenceAsTableImpl const& collection,
                               INumber removed, INumber previous) const
{ collection.UpdateMngCursorsForPredRemove (removed, previous);
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForRemoveOf (ISequenceAsTableImpl const& collection,
                             INumber index) const
{ collection.UpdateMngCursorsForRemoveOf (index);
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForShiftLeftOf (ISequenceAsTableImpl const& collection,
                                INumber index) const
{ collection.UpdateMngCursorsForShiftLeftOf (index);
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForShiftRightOf (ISequenceAsTableImpl const& collection,
                                 INumber index) const
{ collection.UpdateMngCursorsForShiftRightOf (index);
}

inline void
IASequenceAsTableOps::
UpdateMngCursorsForSwap (ISequenceAsTableImpl const& collection,
                         INumber index1, INumber index2) const
{ collection.UpdateMngCursorsForSwap (index1, index2);
}
