/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISETAVL_H
#define _IISETAVL_H

#include <iisetks.h>


#include <iiksavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISetOnKeySetImpl
         <IKeySetAsAvlTreeImpl> ISetAsAvlTreeImpl;

template <class Element, class ElementOps, class Implementation>
class ISetAsAvlTreeOps :
  public IASetOnKeySetOps <IKeySetAsAvlTreeImpl> {

  typedef  ISetAsAvlTreeOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySetAsAvlTreeOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISetAsAvlTreeOps
                           (INumber);

           ISetAsAvlTreeOps
                           (INumber, void*);

           ISetAsAvlTreeOps
                           (ISetAsAvlTreeOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISetAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iisetavl.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
