/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISETLST_H
#define _IISETLST_H

#include <iisetks.h>


#include <iikslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISetOnKeySetImpl
         <IKeySetAsListImpl> ISetAsListImpl;

template <class Element, class ElementOps, class Implementation>
class ISetAsListOps :
  public IASetOnKeySetOps <IKeySetAsListImpl> {

  typedef  ISetAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySetAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISetAsListOps
                           (INumber);

           ISetAsListOps
                           (INumber, void*);

           ISetAsListOps
                           (ISetAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySetAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iisetlst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
