/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISETTAB_H
#define _IISETTAB_H

#include <iisetks.h>


#include <iikstab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISetOnKeySetImpl
         <IKeySetAsTableImpl> ISetAsTableImpl;

template <class Element, class ElementOps, class Implementation>
class ISetAsTableOps :
  public IASetOnKeySetOps <IKeySetAsTableImpl> {

  typedef  ISetAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySetAsTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISetAsTableOps
                           (INumber);

           ISetAsTableOps
                           (INumber, void*);

           ISetAsTableOps
                           (ISetAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISetAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySetAsTableImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iisettab.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
