/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISSBST_H
#define _IISSBST_H

#include <iisskss.h>


#include <iikssbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsBstTreeImpl> ISortedSetAsBstTreeImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsBstTreeImpl> IASortedSetAsBstTreeOps;

template <class Element, class ElementOps, class Implementation>
class ISortedSetAsBstTreeOps :
  public IASortedSetAsBstTreeOps {

  typedef  ISortedSetAsBstTreeOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsBstTreeOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsBstTreeOps
                           (INumber);

           ISortedSetAsBstTreeOps
                           (INumber, void*);

           ISortedSetAsBstTreeOps
                           (ISortedSetAsBstTreeOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iissbst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
