/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISSKSS_H
#define _IISSKSS_H

#include <iiass.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Base>
class ISortedSetOnKeySortedSetMngCursorImpl;

template <class Base>
class ISortedSetOnKeySortedSetImpl;

template <class Base>
class ISortedSetOnKeySortedSetMngCursorImpl : public Base::MngCursor {

  typedef  Base::MngCursor Inherited;

public:

           ISortedSetOnKeySortedSetMngCursorImpl
                            (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

protected:

private:


};

template <class Base>
class IASortedSetOnKeySortedSetOps;

template <class Base>
class ISortedSetOnKeySortedSetImpl : public IASortedSetImpl {

  typedef  IASortedSetImpl Inherited;

  typedef  ISortedSetOnKeySortedSetImpl <Base> Self;

public:

  typedef  IASortedSetOnKeySortedSetOps <Base> Ops;

  typedef  Base::Cursor Cursor;

  typedef  ISortedSetOnKeySortedSetMngCursorImpl <Base> MngCursor;

           ISortedSetOnKeySortedSetImpl
                            (Ops&, INumber);

           ISortedSetOnKeySortedSetImpl
                            (Ops&,
                             ISortedSetOnKeySortedSetImpl
                              <Base> const&);

          ~ISortedSetOnKeySortedSetImpl
                            ();

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  IBoolean AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  IBoolean CheckCursor      (ICursorImpl const&) const;

  IBoolean CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  IBoolean Contains         (void const*) const;

  IBoolean ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  IBoolean IsBounded        () const;

  IBoolean IsConsistent     () const;

  IBoolean IsEmpty          () const;

  IBoolean IsFirstAt        (ICursorImpl const&) const;

  IBoolean IsFull           () const;

  IBoolean IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  IBoolean Locate           (void const*, ICursorImpl&) const;

  IBoolean LocateNext       (void const*, ICursorImpl&) const;

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  IBoolean SetToFirst       (ICursorImpl&) const;

  IBoolean SetToLast        (ICursorImpl&) const;

  IBoolean SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  IBoolean SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

  IBoolean operator==       (IASortedSetImpl const&) const;

  TStream& operator<<=      (TStream&);

  TStream& operator>>=      (TStream&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

  friend
  class    ISortedSetOnKeySortedSetMngCursorImpl <Base>;


};

template <class Base>
class IASortedSetOnKeySortedSetOps {
public:

  virtual ~IASortedSetOnKeySortedSetOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:


};

#pragma SOMAsDefault (pop)

#include <iisskss.inl>


#pragma info (restore)
#pragma pack ()

#endif
