/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IISSLST_H
#define _IISSLST_H

#include <iisskss.h>


#include <iiksslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsListImpl> ISortedSetAsListImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsListImpl> IASortedSetAsListOps;

template <class Element, class ElementOps, class Implementation>
class ISortedSetAsListOps :
  public IASortedSetAsListOps {

  typedef  ISortedSetAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsListOps
                           (INumber);

           ISortedSetAsListOps
                           (INumber, void*);

           ISortedSetAsListOps
                           (ISortedSetAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsListImpl&
                           ();

           operator Implementation*
                           ();


protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iisslst.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
