/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IVEqualitySequenceImpl
// ---

// public members

template <class VInherited>
IVEqualitySequenceImpl <VInherited>::
IVEqualitySequenceImpl (Ops& ops, INumber numberOfElements)
: VInherited (ops, numberOfElements)
{
}

template <class VInherited>
IVEqualitySequenceImpl <VInherited>::
IVEqualitySequenceImpl
  (Ops& ops, IVEqualitySequenceImpl <VInherited> const& collection)
: VInherited (ops, collection)
{
}

template <class VInherited>
IBoolean
IVEqualitySequenceImpl <VInherited>::
Add (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenAdded = VInherited::Add (element, cursor);
  EnableNotification (isEnabled);
  if (hasBeenAdded && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAllFrom (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
AddAsFirst (void const* element, ICursorImpl& cursor)
{ VInherited::AddAsFirst (element, cursor);
  if (HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
AddAsLast (void const* element, ICursorImpl& cursor)
{ VInherited::AddAsLast (element, cursor);
  if (HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
AddAsNext (void const* element, ICursorImpl& cursor)
{ VInherited::AddAsNext (element, cursor);
  if (HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
AddAsPrevious (void const* element, ICursorImpl& cursor)
{ VInherited::AddAsPrevious (element, cursor);
  if (HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
AddAtPosition (IPosition position,
               void const* element,
               ICursorImpl& cursor)
{ VInherited::AddAtPosition (position, element, cursor);
  if (HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
Copy (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Copy (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
IBoolean
IVEqualitySequenceImpl <VInherited>::
LocateOrAdd (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenLocated = VInherited::LocateOrAdd (element, cursor);
  EnableNotification (isEnabled);
  if (! hasBeenLocated && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenLocated;
}

template <class VInherited>
IBoolean
IVEqualitySequenceImpl <VInherited>::
Remove (void const* element)
{ if (HasObservers () &&  Locate (element, CursorOf (*this))) {
    NotifyOfRemoveAt (CursorOf (*this));
  }
  return VInherited::Remove (element);
}

template <class VInherited>
INumber
IVEqualitySequenceImpl <VInherited>::
RemoveAll ()
{ INumber result = VInherited::RemoveAll ();
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVEqualitySequenceImpl <VInherited>::
RemoveAll (IPredFunc predFunc, void* addArg)
{ INumber result = VInherited::RemoveAll (predFunc, addArg);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVEqualitySequenceImpl <VInherited>::
RemoveAllOccurrences (void const* element)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  INumber result = VInherited::RemoveAllOccurrences (element);
  EnableNotification (isEnabled);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
RemoveAt (ICursorImpl& cursor)
{ if (HasObservers ()) {
    NotifyOfRemoveAt (cursor);
  }
  VInherited::RemoveAt (cursor);
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
RemoveAtPosition (IPosition position)
{ if (HasObservers ()) {
    SetToPosition (position, CursorOf (*this));
    NotifyOfRemoveAt (CursorOf (*this));
  }
  VInherited::RemoveAtPosition (position);
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
RemoveFirst ()
{ if (HasObservers ()) {
    SetToFirst (CursorOf (*this));
    NotifyOfRemoveAt (CursorOf (*this));
  }
  VInherited::RemoveFirst ();
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
RemoveLast ()
{ if (HasObservers ()) {
    SetToLast (CursorOf (*this));
    NotifyOfRemoveAt (CursorOf (*this));
  }
  VInherited::RemoveLast ();
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
Reverse ()
{ VInherited::Reverse ();
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVEqualitySequenceImpl <VInherited>::
Sort (ICompFunc compFunc, void* addArg)
{ VInherited::Sort (compFunc, addArg);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

#pragma info (restore)
#pragma pack ()
