/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IVHeapImpl
// ---

// public members

template <class VInherited>
IVHeapImpl <VInherited>::
IVHeapImpl (Ops& ops, INumber numberOfElements)
: VInherited (ops, numberOfElements)
{
}

template <class VInherited>
IVHeapImpl <VInherited>::
IVHeapImpl
  (Ops& ops, IVHeapImpl <VInherited> const& collection)
: VInherited (ops, collection)
{
}

template <class VInherited>
IBoolean
IVHeapImpl <VInherited>::
Add (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenAdded = VInherited::Add (element, cursor);
  EnableNotification (isEnabled);
  if (hasBeenAdded && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVHeapImpl <VInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAllFrom (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVHeapImpl <VInherited>::
Copy (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Copy (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
INumber
IVHeapImpl <VInherited>::
RemoveAll ()
{ INumber result = VInherited::RemoveAll ();
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVHeapImpl <VInherited>::
RemoveAll (IPredFunc predFunc, void* addArg)
{ INumber result = VInherited::RemoveAll (predFunc, addArg);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
void
IVHeapImpl <VInherited>::
RemoveAt (ICursorImpl& cursor)
{ if (HasObservers ()) {
    NotifyOfRemoveAt (cursor);
  }
  VInherited::RemoveAt (cursor);
}

template <class VInherited>
void
IVHeapImpl <VInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
}

#pragma info (restore)
#pragma pack ()
