/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIVREL_H
#define _IIVREL_H

#include <iiarel.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class VInherited>
class IVRelationImpl : public VInherited {
public:

  typedef  VInherited::Ops Ops;

           IVRelationImpl
                            (Ops&, INumber);

           IVRelationImpl
                            (Ops&, IVRelationImpl
                                    <VInherited> const&);

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IARelationImpl const&,
                             IARelationImpl const&);

  void     AddDifference    (IARelationImpl const&,
                             IARelationImpl const&);

  void     AddIntersection  (IARelationImpl const&,
                             IARelationImpl const&);

  void     AddUnion         (IARelationImpl const&,
                             IARelationImpl const&);

  void     Antivalence      (IARelationImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IARelationImpl const&);

  void     Intersection     (IARelationImpl const&);

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Union            (IARelationImpl const&);

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iivrel.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
