/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIVSEQ_H
#define _IIVSEQ_H

#include <iiaseq.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class VInherited>
class IVSequenceImpl : public VInherited {
public:

  typedef  VInherited::Ops Ops;

           IVSequenceImpl
                            (Ops&, INumber);

           IVSequenceImpl
                            (Ops&, IVSequenceImpl
                                    <VInherited> const&);

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Reverse          ();

  void     Sort             (ICompFunc, void*);

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iivseq.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
