/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IVSetImpl
// ---

// public members

template <class VInherited>
IVSetImpl <VInherited>::
IVSetImpl (Ops& ops, INumber numberOfElements)
: VInherited (ops, numberOfElements)
{
}

template <class VInherited>
IVSetImpl <VInherited>::
IVSetImpl
  (Ops& ops, IVSetImpl <VInherited> const& collection)
: VInherited (ops, collection)
{
}

template <class VInherited>
IBoolean
IVSetImpl <VInherited>::
Add (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenAdded = VInherited::Add (element, cursor);
  EnableNotification (isEnabled);
  if (hasBeenAdded && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVSetImpl <VInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAllFrom (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
AddAntivalence (IASetImpl const& collection1,
                IASetImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAntivalence (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
AddDifference (IASetImpl const& collection1,
               IASetImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddDifference (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
AddIntersection (IASetImpl const& collection1,
               IASetImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddIntersection (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
AddUnion (IASetImpl const& collection1,
          IASetImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddUnion (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
Antivalence (IASetImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Antivalence (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}
template <class VInherited>
void
IVSetImpl <VInherited>::
Copy (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Copy (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
Difference (IASetImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Difference (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSetImpl <VInherited>::
Intersection (IASetImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Intersection (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}
template <class VInherited>
IBoolean
IVSetImpl <VInherited>::
LocateOrAdd (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenLocated = VInherited::LocateOrAdd (element, cursor);
  EnableNotification (isEnabled);
  if (! hasBeenLocated && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenLocated;
}

template <class VInherited>
IBoolean
IVSetImpl <VInherited>::
Remove (void const* element)
{ if (HasObservers () &&  Locate (element, CursorOf (*this))) {
    NotifyOfRemoveAt (CursorOf (*this));
  }
  return VInherited::Remove (element);
}

template <class VInherited>
INumber
IVSetImpl <VInherited>::
RemoveAll ()
{ INumber result = VInherited::RemoveAll ();
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVSetImpl <VInherited>::
RemoveAll (IPredFunc predFunc, void* addArg)
{ INumber result = VInherited::RemoveAll (predFunc, addArg);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVSetImpl <VInherited>::
RemoveAllOccurrences (void const* element)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  INumber result = VInherited::RemoveAllOccurrences (element);
  EnableNotification (isEnabled);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
void
IVSetImpl <VInherited>::
RemoveAt (ICursorImpl& cursor)
{ if (HasObservers ()) {
    NotifyOfRemoveAt (cursor);
  }
  VInherited::RemoveAt (cursor);
}

template <class VInherited>
void
IVSetImpl <VInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
}

template <class VInherited>
void
IVSetImpl <VInherited>::
Union (IASetImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Union (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

#pragma info (restore)
#pragma pack ()
