/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIVSET_H
#define _IIVSET_H

#include <iiaset.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class VInherited>
class IVSetImpl : public VInherited {
public:

  typedef  VInherited::Ops Ops;

           IVSetImpl
                            (Ops&, INumber);

           IVSetImpl
                            (Ops&, IVSetImpl
                                    <VInherited> const&);

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASetImpl const&,
                             IASetImpl const&);

  void     AddDifference    (IASetImpl const&,
                             IASetImpl const&);

  void     AddIntersection  (IASetImpl const&,
                             IASetImpl const&);

  void     AddUnion         (IASetImpl const&,
                             IASetImpl const&);

  void     Antivalence      (IASetImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASetImpl const&);

  void     Intersection     (IASetImpl const&);

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IASetImpl const&);

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iivset.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
