/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IVSortedMapImpl
// ---

// public members

template <class VInherited>
IVSortedMapImpl <VInherited>::
IVSortedMapImpl (Ops& ops, INumber numberOfElements)
: VInherited (ops, numberOfElements)
{
}

template <class VInherited>
IVSortedMapImpl <VInherited>::
IVSortedMapImpl
  (Ops& ops, IVSortedMapImpl <VInherited> const& collection)
: VInherited (ops, collection)
{
}

template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
Add (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenAdded = VInherited::Add (element, cursor);
  EnableNotification (isEnabled);
  if (hasBeenAdded && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAllFrom (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
AddAntivalence (IASortedMapImpl const& collection1,
                IASortedMapImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAntivalence (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
AddDifference (IASortedMapImpl const& collection1,
               IASortedMapImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddDifference (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
AddIntersection (IASortedMapImpl const& collection1,
               IASortedMapImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddIntersection (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
AddUnion (IASortedMapImpl const& collection1,
          IASortedMapImpl const& collection2)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddUnion (collection1, collection2);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
Antivalence (IASortedMapImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Antivalence (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}
template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
AddOrReplaceElementWithKey (void const* element, ICursorImpl& cursor)
{ IBoolean hasBeenAdded = false;
  if (VInherited::LocateElementWithKey (Key (element), cursor)) {
    if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
      NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
      NotifyOfReplaceAt (cursor, element);
#endif
    }
    VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
    if (HasObservers ()) {
      NotifyOfAddAt (cursor); // to be removed in a future release
    }
#endif
  }
  else {
    hasBeenAdded = VInherited::Add (element, cursor);
    if (HasObservers ()) {
      NotifyOfAddAt (cursor);
    }
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
Copy (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Copy (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
Difference (IASortedMapImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Difference (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
Intersection (IASortedMapImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Intersection (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}
template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
LocateOrAdd (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenLocated = VInherited::LocateOrAdd (element, cursor);
  EnableNotification (isEnabled);
  if (! hasBeenLocated && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenLocated;
}

template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
LocateOrAddElementWithKey (void const* key, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenLocated =
    VInherited::LocateOrAddElementWithKey (key, cursor);
  EnableNotification (isEnabled);
  if (!hasBeenLocated && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenLocated;
}

template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
Remove (void const* element)
{ if (HasObservers () &&  Locate (element, CursorOf (*this))) {
    NotifyOfRemoveAt (CursorOf (*this));
  }
  return VInherited::Remove (element);
}

template <class VInherited>
INumber
IVSortedMapImpl <VInherited>::
RemoveAll ()
{ INumber result = VInherited::RemoveAll ();
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVSortedMapImpl <VInherited>::
RemoveAll (IPredFunc predFunc, void* addArg)
{ INumber result = VInherited::RemoveAll (predFunc, addArg);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVSortedMapImpl <VInherited>::
RemoveAllElementsWithKey (void const* key)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  INumber result = VInherited::RemoveAllElementsWithKey (key);
  EnableNotification (isEnabled);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVSortedMapImpl <VInherited>::
RemoveAllOccurrences (void const* element)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  INumber result = VInherited::RemoveAllOccurrences (element);
  EnableNotification (isEnabled);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
RemoveAt (ICursorImpl& cursor)
{ if (HasObservers ()) {
    NotifyOfRemoveAt (cursor);
  }
  VInherited::RemoveAt (cursor);
}

template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
RemoveElementWithKey (void const* key)
{ if (HasObservers () &&
      LocateElementWithKey (key, CursorOf (*this))) {
    NotifyOfRemoveAt (CursorOf (*this));
  }
  return VInherited::RemoveElementWithKey (key);
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
RemoveAtPosition (IPosition position)
{ if (HasObservers ()) {
    SetToPosition (position, CursorOf (*this));
    NotifyOfRemoveAt (CursorOf (*this));
  }
  VInherited::RemoveAtPosition (position);
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
RemoveFirst ()
{ if (HasObservers ()) {
    SetToFirst (CursorOf (*this));
    NotifyOfRemoveAt (CursorOf (*this));
  }
  VInherited::RemoveFirst ();
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
RemoveLast ()
{ if (HasObservers ()) {
    SetToLast (CursorOf (*this));
    NotifyOfRemoveAt (CursorOf (*this));
  }
  VInherited::RemoveLast ();
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
}

template <class VInherited>
IBoolean
IVSortedMapImpl <VInherited>::
ReplaceElementWithKey (void const* element, ICursorImpl& cursor)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  IBoolean hasBeenReplaced =
    VInherited::ReplaceElementWithKey (element, cursor);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
  return hasBeenReplaced;
}

template <class VInherited>
void
IVSortedMapImpl <VInherited>::
Union (IASortedMapImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Union (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

#pragma info (restore)
#pragma pack ()
