/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKB_H
#define _IKB_H

#include <iakb.h>
#include <iickb.h>
#include <iivkb.h>
#include <iikbhsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeyBag;

template <class Element, class Key, class ElementOps>
class IGKeyBagCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeyBag
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagCursor
                            (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeyBag :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBag <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeyBagCursor
            <Element, Key, ElementOps> Cursor;


           IGKeyBag
                            (INumber = 100);

           IGKeyBag
                            (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBag <Element, Key, ElementOps>&
           operator=        (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeyBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeyBag :
  public IGKeyBag
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IGKeyBag
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef  IKeyBag <Element, Key> Self;

#define IKeyBagTypedef(Element, Key)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeyBag
                            (INumber = 100);


protected:

           IKeyBag
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeyBag :
  public IGKeyBag
          <Element, Key, ElementOps > {

  typedef  IVGKeyBag
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagTypedef (Element, Key, ElementOps);

public:

           IVGKeyBag
                            (INumber = 100);


protected:

           IVGKeyBag
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeyBag :
  public IVGKeyBag
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IVGKeyBag
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef  IVKeyBag <Element, Key> Self;

#define IVKeyBagTypedef(Element, Key)\
  typedef  IVKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeyBag
                            (INumber = 100);


protected:

           IVKeyBag
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikb.inl>

#pragma info (restore)
#pragma pack ()

#endif
