/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeyBagCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagCursor <Element, Key, ElementOps>::
IGKeyBagCursor
  (IGKeyBag
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagCursor <Element, Key, ElementOps>&
IGKeyBagCursor <Element, Key, ElementOps>::
operator=
  (IGKeyBagCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagCursor <Element, Key, ElementOps>::
IGKeyBagCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeyBag
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBag <Element, Key, ElementOps>::
IGKeyBag (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeyBag <Element, Key, ElementOps>::
IGKeyBag
  (IGKeyBag
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBag <Element, Key, ElementOps>&
IGKeyBag <Element, Key, ElementOps>::
operator= (IGKeyBag
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBag <Element, Key, ElementOps>::
IGKeyBag (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBag
 <Element, Key, ElementOps>::Implementation&
IGKeyBag <Element, Key, ElementOps>::
ImplOf (IGKeyBag
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeyBag
// ---

// public members

template <class Element, class Key>
inline
IKeyBag <Element, Key>::
IKeyBag (INumber numberOfElements)
: IGKeyBag
   <Element, Key, IKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeyBag <Element, Key>::
IKeyBag (PureImplementation& impl)
: IGKeyBag
   <Element, Key, IKEHOps <Element, Key> > (impl)
{
}

// ---
// IVGKeyBag
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBag <Element, Key, ElementOps>::
IVGKeyBag (INumber numberOfElements)
: IGKeyBag
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBag <Element, Key, ElementOps>::
IVGKeyBag (PureImplementation& impl)
: IGKeyBag
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeyBag
// ---

// public members

template <class Element, class Key>
inline
IVKeyBag <Element, Key>::
IVKeyBag (INumber numberOfElements)
: IVGKeyBag
   <Element, Key, IKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeyBag <Element, Key>::
IVKeyBag (PureImplementation& impl)
: IVGKeyBag
   <Element, Key, IKEHOps <Element, Key> > (impl)
{
}
