/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKBHSH_H
#define _IKBHSH_H

#include <iakb.h>
#include <iickb.h>
#include <iivkb.h>
#include <iikbhsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsHshTable;

template <class Element, class Key, class ElementOps>
class IGKeyBagAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeyBagAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsHshTableCursor
                            (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsHshTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeyBagAsHshTable :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsHshTable <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeyBagAsHshTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeyBagAsHshTable
                            (INumber = 100);

           IGKeyBagAsHshTable
                            (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsHshTable <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeyBagAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsHshTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeyBagAsHshTable :
  public IGKeyBagAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IGKeyBagAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef  IKeyBagAsHshTable <Element, Key> Self;

#define IKeyBagAsHshTableTypedef(Element, Key)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeyBagAsHshTable
                            (INumber = 100);


protected:

           IKeyBagAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeyBagAsHshTable :
  public IGKeyBagAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsHshTableTypedef (Element, Key, ElementOps);

public:

           IVGKeyBagAsHshTable
                            (INumber = 100);


protected:

           IVGKeyBagAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeyBagAsHshTable :
  public IVGKeyBagAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IVGKeyBagAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef  IVKeyBagAsHshTable <Element, Key> Self;

#define IVKeyBagAsHshTableTypedef(Element, Key)\
  typedef  IVKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeyBagAsHshTable
                            (INumber = 100);


protected:

           IVKeyBagAsHshTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikbhsh.inl>

#pragma info (restore)
#pragma pack ()

#endif
