/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKBLST_H
#define _IKBLST_H

#include <iakb.h>
#include <iickb.h>
#include <iivkb.h>
#include <iikblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsList;

template <class Element, class Key, class ElementOps>
class IGKeyBagAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeyBagAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsListCursor
                            (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeyBagAsList :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsList <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeyBagAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGKeyBagAsList
                            (INumber = 100);

           IGKeyBagAsList
                            (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsList <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeyBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeyBagAsList :
  public IGKeyBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeyBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeyBagAsList <Element, Key> Self;

#define IKeyBagAsListTypedef(Element, Key)\
  typedef  IKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeyBagAsList
                            (INumber = 100);


protected:

           IKeyBagAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeyBagAsList :
  public IGKeyBagAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsListTypedef (Element, Key, ElementOps);

public:

           IVGKeyBagAsList
                            (INumber = 100);


protected:

           IVGKeyBagAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeyBagAsList :
  public IVGKeyBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeyBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeyBagAsList <Element, Key> Self;

#define IVKeyBagAsListTypedef(Element, Key)\
  typedef  IVKeyBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeyBagAsList
                            (INumber = 100);


protected:

           IVKeyBagAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikblst.inl>

#pragma info (restore)
#pragma pack ()

#endif
