/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeyBagAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsListCursor <Element, Key, ElementOps>::
IGKeyBagAsListCursor
  (IGKeyBagAsList
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsListCursor <Element, Key, ElementOps>&
IGKeyBagAsListCursor <Element, Key, ElementOps>::
operator=
  (IGKeyBagAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsListCursor <Element, Key, ElementOps>::
IGKeyBagAsListCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeyBagAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsList <Element, Key, ElementOps>::
IGKeyBagAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsList <Element, Key, ElementOps>::
IGKeyBagAsList
  (IGKeyBagAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsList <Element, Key, ElementOps>&
IGKeyBagAsList <Element, Key, ElementOps>::
operator= (IGKeyBagAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsList <Element, Key, ElementOps>::
IGKeyBagAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsList
 <Element, Key, ElementOps>::Implementation&
IGKeyBagAsList <Element, Key, ElementOps>::
ImplOf (IGKeyBagAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeyBagAsList
// ---

// public members

template <class Element, class Key>
inline
IKeyBagAsList <Element, Key>::
IKeyBagAsList (INumber numberOfElements)
: IGKeyBagAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeyBagAsList <Element, Key>::
IKeyBagAsList (PureImplementation& impl)
: IGKeyBagAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeyBagAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsList <Element, Key, ElementOps>::
IVGKeyBagAsList (INumber numberOfElements)
: IGKeyBagAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsList <Element, Key, ElementOps>::
IVGKeyBagAsList (PureImplementation& impl)
: IGKeyBagAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeyBagAsList
// ---

// public members

template <class Element, class Key>
inline
IVKeyBagAsList <Element, Key>::
IVKeyBagAsList (INumber numberOfElements)
: IVGKeyBagAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeyBagAsList <Element, Key>::
IVKeyBagAsList (PureImplementation& impl)
: IVGKeyBagAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
